@extends('admin.layouts.master')

@section('content')
<!-- BEGIN PAGE HEADER-->
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/">Home</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/admin">Dashboard</a>
        </li>
    </ul>

</div>

<h3 class="page-title">
    Dashboard
    <small>reports & statistics</small>
</h3>

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-md-12">
        <div class="portlet box blue">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-users"></i>Manage Dashboard
                </div>
            </div>
            <div class="portlet-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="core-box">
                            <div class="heading">
                                <i class="clip-database circle-icon circle-dark-blue"></i>

                                <h2>Manage Users & Settings</h2>
                            </div>
                            <div class="content">
                                View and manage users and site wide settings . You can see details of all users and you
                                can edit user details if necessary, including user roles and deleting users. You can
                                also change site wide settings
                            </div>

                            <br>

                            <div class="btn-group btn-group-justified">
                                <a class="btn btn-primary" href="/admin/users/create">
                                    New User <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-primary" href="/admin/users/all">
                                    All Users <i class="clip-arrow-right-2"></i>
                                </a>
                            </div>
                            <br/>

                            <div class="btn-group btn-group-justified">
                                <a class="btn btn-success" href="/admin/settings">
                                    Settings <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-success" href="/admin/statistics">
                                    Analytics <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-success" href="/admin/ads">
                                    Ads <i class="clip-arrow-right-2"></i>
                                </a>
                            </div>

                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="core-box">
                            <div class="heading">
                                <i class="clip-folder circle-icon circle-dark-blue"></i>

                                <h2>Content Management</h2>
                            </div>
                            <div class="content">
                                Easily add content to your website. This includes adding a article or categories
                                which will automatically post the content to the home page also.
                            </div>

                            </br>

                            <div class="btn-group btn-group-justified">
                                <a class="btn btn-primary" href="/admin/posts/create">
                                    Create new post <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-primary" href="/admin/posts">
                                    All Posts <i class="clip-arrow-right-2"></i>
                                </a>
                            </div>
                            <br/>

                            <div class="btn-group btn-group-justified">
                                <a class="btn btn-success" href="/admin/categories/create">
                                    New Category <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-success" href="/admin/categories">
                                    Categories <i class="clip-arrow-right-2"></i>
                                </a>

                            </div>
                            <br/>

                            <div class="btn-group btn-group-justified">
                                <a class="btn btn-default" href="/admin/sources/create">
                                    New Source <i class="clip-arrow-right-2"></i>
                                </a>
                                <a class="btn btn-default" href="/admin/sources">
                                    All Sources <i class="clip-arrow-right-2"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="row">
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                <div class="dashboard-stat blue-madison">
                    <div class="visual">
                        <i class="fa fa-shopping-cart"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                            {{$sources_count}}
                        </div>
                        <div class="desc">
                            No of Sources
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                <div class="dashboard-stat yellow-casablanca">
                    <div class="visual">
                        <i class="fa fa-shopping-cart"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                            {{$posts_count}}
                        </div>
                        <div class="desc">
                            No of Posts
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                <div class="dashboard-stat green-haze">
                    <div class="visual">
                        <i class="fa fa-bar-chart-o"></i>
                    </div>
                    <div class="details">
                        <div class="number">
                            {{$users_count}}
                        </div>
                        <div class="desc">
                            All Users
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@stop